# JSON Likelihoods for ATLAS SUSY 2-lepton 0-jet (SUSY-2018-32)

The JSON likelihoods are serialized for each signal interpretation: [Charginos to Sleptons (C1C1SlepSnu)](./C1C1SlepSnu_patchset.json), [Charginos to W-bosons (C1C1WW)](./C1C1WW_patchset.json), and [Direct Sleptons (SlepSlep)](./SlepSlep_patchset.json). This is done by providing a background-only workspace `bkgonly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `{signal}_patchset.json`.

Each [jsonpatch](http://jsonpatch.com/) file follows the format `spec_[region]_signal[dsid]_[m1]_[m2].json` where `dsid` is the ID of the signal sample, `m1` is the mass of the gluino (for Regions A and B) or the stop squark (for Combined Region), and `m2` is the mass of the lightest supersymmetric particle (LSP; for Combined Region) or the mass of the stop squark (for Regions A and B).

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:
```
jq '.patches[].metadata.name' SlepSlep_patchset.json
```
shown here for direct sleptons only. This can be done with `pyhf` via

```
pyhf patchset inspect SlepSlep_patchset.json
```

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch bkgonly.json <(pyhf patchset extract SlepSlep_patchset.json --name "SlepSlep_direct_500_1") > SlepSlep_direct_500_1.json
```
here shown as an example for a signal model `SlepSlep_direct_500_1` for slepton mass 500 GeV and neutralino mass of 1 GeV.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls bkgonly.json -p <(pyhf patchset extract SlepSlep_patchset.json --name "SlepSlep_direct_500_1")

jsonpatch bkgonly.json <(pyhf patchset extract SlepSlep_patchset.json --name "SlepSlep_direct_500_1") | pyhf cls

pyhf cls SlepSlep_direct_500_1.json
```
