#include "SimpleAnalysis/AnalysisClass.h"

DefineAnalysis(StopMultiBJets2018)

void StopMultiBJets2018::Init(){
  //Define Signal Regions
  addRegions({"preSelection",
	"6je4be", "6je5bi", "7je4be", "7je5bi", "8je4be", "8je5bi", "9ji4be", "9ji5bi"
	});
  
  //Define Histograms
  addHistogram("NBJets_5j",4,1.5,5.5);
  addHistogram("NBJets_6j",4,1.5,5.5);
  addHistogram("NBJets_7j",4,1.5,5.5);
  addHistogram("NBJets_8j",4,1.5,5.5);
  addHistogram("NBJets_9j",4,1.5,5.5);
  addHistogram("Ntotal",1,0.5,1.5);
  addHistogram("MCweight",100,0.,2.);
  
}

void StopMultiBJets2018::ProcessEvent(AnalysisEvent *event)
{
	auto baseElectrons = event->getElectrons(10,2.47,EMediumLH);
	auto baseMuons     = event->getMuons(10,2.5, MuLoose);
	auto baseJets      = event->getJets(25.,2.5);
	auto baseLeptons   = baseElectrons + baseMuons;

	// overlap removal
	//baseElectrons  	= overlapRemoval(baseElectrons, baseMuons, 0.01);
	//auto Jets       = overlapRemoval(baseJets, baseElectrons, 0.2, NOT(BTag60MV2c10));
	auto Jets       = overlapRemoval(baseJets, baseElectrons, 0.2, NOT(BTag85MV2c10));
	auto Electrons  = overlapRemoval(baseElectrons, Jets, 0.4);
	Jets            = overlapRemoval(Jets, baseMuons, 0.4, LessThan3Tracks);
	if (Jets.size() > 0) sortObjectsByPt(Jets);
	auto Muons      = overlapRemoval(baseMuons, Jets, 0.4);
	auto Leptons    = Electrons + Muons;

	// signal objects
	//For mc16a
	auto triggerlJets      = filterObjects(Jets,120.,2.5);
	//For mc16d and mc16e
	//auto triggerlJets      = filterObjects(Jets,140.,2.5);
	
	auto bjets             = filterObjects(Jets,25.,2.5,BTag60MV2c10);
	//Testing
	//auto bjets             = filterObjects(Jets,25.,2.5,BTag60MV2c10);
 
	int nBJets = bjets.size();
	int nJets  = Jets.size();
	//std::cout << " runNumber: "<< event->getMCNumber() << " ,randomrunNumber: "<< event->getSUSYChannel() << std::endl;



	float  mc_weight        = event->getMCWeights()[0];
	
	fill("Ntotal",1.);
	fill("MCweight",mc_weight);

	ntupVar("nJets", nJets);
	ntupVar("nBJets", nBJets);
	  
	// Signal regions
	if ( Leptons.size()==0 && triggerlJets.size()>=4 && nBJets>=2 ) {
	  accept("preSelection");
	  
	  if ( nJets==5 ){
	    if( nBJets >= 5 ) fill("NBJets_5j",5);
	    else fill("NBJets_5j",nBJets);
	  }

	  if ( nJets==6 ){
	    if( nBJets >= 5 ) fill("NBJets_6j",5);
	    else fill("NBJets_6j",nBJets);
	  }

	  if ( nJets==7 ){
	    if( nBJets >= 5 ) fill("NBJets_7j",5);
	    else fill("NBJets_7j",nBJets);
	  }

	  if ( nJets==8 ){
	    if( nBJets >= 5 ) fill("NBJets_8j",5);
	    else fill("NBJets_8j",nBJets);
	  }

	  if ( nJets>=9 ){
	    if( nBJets >= 5 ) fill("NBJets_9j",5);
	    else fill("NBJets_9j",nBJets);
	  }
	  
	  // Region classification
	  if ( nJets==6 && nBJets==4 ) accept("6je4be");
	  if ( nJets==6 && nBJets>=5 ) accept("6je5bi");
	  
	  if ( nJets==7 && nBJets==4 ) accept("7je4be");
	  if ( nJets==7 && nBJets>=5 ) accept("7je5bi");
	  
	  if ( nJets==8 && nBJets==4 ) accept("8je4be");
	  if ( nJets==8 && nBJets>=5 ) accept("8je5bi");
	  
	  if ( nJets>=9 && nBJets==4 ) accept("9ji4be");
	  if ( nJets>=9 && nBJets>=5 ) accept("9ji5bi");

	  
	}

	
	return;
}
