# JSON Likelihoods for ATLAS SUSY RPV 3L Analysis

The JSON likelihoods are provided in this folder.  Using [pyhf](https://scikit-hep.org/pyhf/), statistical analysis can be easily performed.

When setting limits on the signal model, a scan is performed over the mass of the chargino and its branching fractions to the different leptons (e, mu, tau) and bosons (Z, W, H).  A coarse scan is performed over the lepton branching fractions: democratic (aka inclusive) , 100% electron, 100% muon, and 100% tau.  A finer scan is performed over the mass and boson branching fractions.  For the 100% electron and 100% muon points, the "direct" leptons (see paper text) in the signal channels are required to be electrons or muons, respectively.  No flavor requirement is used for the inclusive and 100% tau points.

Background-only workspaces containing the signal and control channels are in the files matching `[lepton flavor]_bkgonly.json`.  A [jsonpatch](http://jsonpatch.com/) is provided for each point in the scan.  The expected yields and the associated modifiers (i.e. systematic uncertainties) for any signal point can be added to the background-only workspace by applying the appropriate jsonpatch.  All jsonpatches are contained in files matching `[lepton flavor]_patchset.json` or `[lepton flavor]_triangle_patchset.json`.  Each patch in a patchset is identified by the `"name"` metadata field, for example: `"name":"brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900"`.

The patchsets matching `[lepton flavor]_patchset.json` contain the signal points used for the exclusion contours drawn in the Z branching fraction vs. chargino mass plane (e.g. [here](https://atlas.web.cern.ch/Atlas/GROUPS/PHYSICS/PAPERS/SUSY-2018-36/fig_09a.png)).
The patchsets matching `[lepton flavor]_triangle_patchset.json` contain the signal points used for the exclusion contours drawn in the Higgs vs. Z branching fraction plane (e.g. [here](https://atlas.web.cern.ch/Atlas/GROUPS/PHYSICS/PAPERS/SUSY-2018-36/figaux_03a.png)).

There is a separate signal channel for each mass bin in SR3l, SR4l, and SRFR.  The naming convention is `[SR name]_[lower edge]_[upper edge]`.  For example, `SRFR_90_110` is the SRFR mass bin spanning 90-110 GeV.

## Producing signal workspaces

As an example, [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) can be used to create a signal workspace:

```
jsonpatch inclusive_bkgonly.json <(pyhf patchset extract inclusive_patchset.json --name "brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900") > brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900.json
```

The lepton flavor must match between the background-only workspace and the patchset.  The signal patchsets with 100% branching fractions to tau leptons must be used with the inclusive background-only workspace. No flavor requirement is placed on the "direct" leptons for these signals, since the tau leptons can decay to either electrons or muons.

## Computing signal workspaces

With [pyhf](https://scikit-hep.org/pyhf/), any of the following commands can be used to calculate CLs values:

```
pyhf cls inclusive_bkgonly.json --backend pytorch -p <(pyhf patchset extract inclusive_patchset.json --name "brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900")

jsonpatch inclusive_bkgonly.json <(pyhf patchset extract inclusive_patchset.json --name "brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900") | pyhf cls --backend pytorch

pyhf cls brZ_60_brH_20_brW_20_bre_33_brm_33_brt_33_mass_900.json --backend pytorch
```

Changing the pyhf backend to pytorch is optional, but it does greatly reduce the computation time (~15m).