This archive contains generator cards for the signal samples of CMS analysis for trijet resonances (https://arxiv.org/abs/2201.02140):

pp -> GKK -> R g -> g g g

where GKK is a Kaluza-Klein gluon and R is a radion in the extended Warped Extra Dimension model with only QCD in the extended bulk proposed by Agashe et al. in 10.1007/JHEP11(2020)109.

We provide the following cards, to be used with madgraph:

- `PROCESSNAME_run_card.dat`: contains run settings, predefined cuts, etc.
- `PROCESSNAME_proc_card.dat`: contains the process definition (i.e., GKK production in pp collision and its decays in radion+gluon, with radion decaying into 2 gluons)
- `PROCESSNAME_extramodels.dat`: specifies the imported model, available in the HEPData page of the analysis: https://www.hepdata.net/record/ins2005439 under "Resources > Radion_GKK_UFO.zip"
- `PROCESSNAME_customizecards.dat`: specific commands to set parameters for the given signal points

The cards contain exemplary values for a WED model with couplings g_grav = 6.0 and g_gkk = 3.0. These values can be changed in lines 14 and 16 of `PROCESSNAME_customizecards.dat`. The masses of the GKK and R can be modified by changing 'GKKMASS' and 'RMASS' with the desired values (in GeV) by editing `PROCESSNAME_customizecards.dat`.

The script createMadgraphCards_Res1ToRes2GluTo3Glu.py can be used to automatically generate copies of the template cards for different GKK masses and R values (in the script R is the ratio between the mass of the radion and the GKK).

Use Example:

python createMadgraphCards_Res1ToRes2GluTo3Glu.py -i template_cards -n Res1ToRes2GluTo3Glu
