# JSON Likelihoods for ATLAS SUSY 2L+jets analysis (SUSY-2018-05)

The JSON likelihoods are serialized for each signal region of the RJR electroweak (RJR), conventional electroweak (EWK), and Strong (STR) searches. This is done by providing a background-only workspace containing the signal channels for each region at `[region]_bkgonly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `[region]_patchset.json`.  Single bin regions used to computer upper limits are provided as `[region]_discovery.json`.  Since the RJR search does not use a signal model, only these discovery likelihoods are provided.

Models are provided as patchsets of [jsonpatchs](http://jsonpatch.com/).  Each entry follows the format `signalModel_m1_m2`, where m1 and m2 are the masses of the sparticles (or branching ratio) for that particular model.  For example in the Strong serach, m1 would be the squark or gluino mass in GeV and m2 the LSP mass.  The EWK models follow a similar naming convention for the electroweakino masses for the C1 and N2 masses or N1 mass and Higgs branching ratio.  For the C1N2 model, m1=m(C1)=m(N2) and m2=m(N1).  For the GMSB model, m1=m(N1) and m2=B(Higgs).

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:
```
jq '.patches[].metadata.name' regionA_patchset.json
```
shown here for Region A only.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch regionA_bkgonly.json <(pyhf patchset extract regionA_patchset.json --name "GG_N2_SLN1_1000_100") > regionA_GG_N2_SLN1_1000_100.json
```
here shown as an example for a signal model `GG_N2_SLN1_1000_100`.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls regionA_bkgonly.json -p <(pyhf patchset extract regionA_patchset.json --name "GG_N2_SLN1_1000_100")

jsonpatch regionA_bkgonly.json <(pyhf patchset extract regionA_patchset.json --name "GG_N2_SLN1_1000_100") | pyhf cls

pyhf cls regionA_GG_N2_SLN1_1000_100.json
```

## Description of files
### Likelihoods RJR
- {description: RJR discovery fit pyhf workspace for SR2L-LOW, location: RJR_SR2L_LOW_discovery.json.tgz}
- {description: RJR discovery fit pyhf background workspace for SR2L-LOW, location: RJR_SR2L_LOW_discovery_bkgonly.json.tgz}
- {description: RJR discovery fit pyhf workspace for SR2L-ISR, location: RJR_SR2L_ISR_discovery.json.tgz}
- {description: RJR discovery fit pyhf background workspace for SR2L-ISR, location: RJR_SR2L_ISR_discovery_bkgonly.json.tgz}
### Likelihoods EWK
- {description: EWK background-only fit pyhf workspace, location: ewk_full_bkgonly.json.tgz}
- {description: EWK exclusion fit background pyhf workspace (pruned more than full), location: ewk_signal_bkgonly.json.tgz}
- {description: EWK exclusion fit background pyhf patch set for GMSB and C1N2 models; the `values` fields are (`C1N2`|`GMSB`; x; y) where x and y are the axes of the respective exclusion contour plots., location: ewk_signal_patchset.json.tgz}
- {description: EWK discovery fit background pyhf workspace, location: ewk_discovery_bkgonly.json.tgz}
- {description: EWK discovery fit pyhf patch set, location: ewk_discovery_patchset.json.tgz}
### Likelihoods Strong
- {description: Strong discovery fit pyhf workspace for SRC; mll in (12--31), location: STR-SRC_12_31_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRC; mll in (12--61), location: STR-SRC_12_61_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRC; mll in (31--81), location: STR-SRC_31_81_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRC; mll in (81--), location: STR-SRC_81__discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRC, location: STR-SRC_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRC. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRC_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRHigh; mll in (12--301), location: STR-SRHigh_12_301_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRHigh; mll in (301--), location: STR-SRHigh_301__discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRHigh, location: STR-SRHigh_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRHigh. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRHigh_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRLow; mll in (101--201), location: STR-SRLow_101_201_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRLow; mll in (101--301), location: STR-SRLow_101_301_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRLow; mll in (12--81), location: STR-SRLow_12_81_discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRLow; mll in (301--), location: STR-SRLow_301__discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRLow, location: STR-SRLow_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRLow. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRLow_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRMed; mll in (101--), location: STR-SRMed_101__discovery_bkgonly.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRMed; mll in (12--101, location: STR-SRMed_12_101_discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRMed, location: STR-SRMed_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRMed. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRMed_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRZHigh; mll in (101--), location: STR-SRZHigh___discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRZHigh, location: STR-SRZHigh_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRZHigh. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRZHigh_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRZLow; mll in (101--), location: STR-SRZLow___discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRZLow, location: STR-SRZLow_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRZLow. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRZLow_patchset.json.tgz}
- {description: Strong discovery fit pyhf workspace for SRZMed; mll in (101--), location: STR-SRZMed___discovery_bkgonly.json.tgz}
- {description: Strong background-only fit pyhf workspace for SRZMed, location: STR-SRZMed_bkgonly.json.tgz}
- {description: Strong pyhf patch set for SRZMed. The values of the patches represent the grid x and y values.  Where x is the gluino or squark mass depending on the grid and y is the N1 (LSP) mass., location: STR-SRZMed_patchset.json.tgz}