# JSON Likelihoods for ATLAS SUSY direct staus analysis

The JSON likelihoods are serialized for each region: [Region-combined](Region-combined), [Region-lowMass](Region-lowMass), and [Region-highMass](Region-highMass). This is done by providing a background-only workspace containing the signal/control/validation channels for each region at `$region/BkgOnly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis. `Region-combined` is a combined fit of the low mass and high mass regions, both of which are provided separately as well.

All [jsonpatches](http://jsonpatch.com/) in a given region are contained in the file `$region/patchset.json`. Each patch is identified in `$region/patchset.json` by the metadata field `"name": "DS_[mst]_[mn2]_Staus"` where `mst` is the mass of the stau slepton and `mn2` is the mass of the second-lightest neutralino. 

## Producing signal workspaces

As an example, we use [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) to make the full json likelihood workspace for the signal point `DS_400_40_Staus`:

```
jsonpatch Region-combined/BkgOnly.json <(pyhf patchset extract Region-combined/patchset.json --name "DS_400_40_Staus") > Region-combined/staus_DS_400_40.json
```

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), you can do any of the following:

```
pyhf cls Region-combined/BkgOnly.json -p <(pyhf patchset extract Region-combined/patchset.json --name "DS_400_40_Staus") 

jsonpatch Region-combined/BkgOnly.json <(pyhf patchset extract Region-combined/patchset.json --name "DS_400_40_Staus") | pyhf cls

pyhf cls Region-combined/staus_DS_400_40.json
```

# Removed Regions

Two mass points were removed due to the lack of sensitivity on the signal:

- (100, 60)
- (120, 80)

As there was no expected signal in the signal regions, these would not participate in the fit and are not useful to preserve/publish.
