# JSON Likelihoods for ATLAS SUSY inclusive same-sign/3L analysis (SUSY-2018-09)

The JSON likelihoods are serialized for each signal region: [Rpc2L0b](Rpc2L0b), [Rpc2L1b](Rpc2L1b), [Rpc2L2b](Rpc2L2b), [Rpc3LSS1b](Rpc3LSS1b) and [Rpv2L](Rpv2L). This is done by providing a background-only workspace containing the signal channels for each region at `[region]_BkgOnly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `[region]_patchset.json`.

Each [jsonpatch](http://jsonpatch.com/) file follows the format `spec_[region]_signal[dsid]_[m1]_[m2].json` where `dsid` is the ID of the signal sample, `m1` is the mass of the gluino (for Rpc2L0b and Rpv2L), the sbottom squark (for Rpc2L1b and Rpc2L2b) or the stop squark (for Rpc3LSS1b), and `m2` is the mass of the lightest supersymmetric particle (LSP; for Rpc2L0b, Rpc2L1b, Rpc2L2b and Rpc3LSS1b) or the mass of the stop squark (for Rpv2L).

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:
```
jq '.patches[].metadata.name' Rpc2L0b_patchset.json
```
shown here for Rpc2L0b only.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch Rpc2L0b_BkgOnly.json <(pyhf patchset extract Rpc2L0b_patchset.json --name "spec_Rpc2L0b_signal376822_1900_800") > Rpc2L0b_spec_Rpc2L0b_signal376822_1900_800.json
```
here shown as an example for a signal model `spec_Rpc2L0b_signal376822_1900_800`.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls Rpc2L0b_BkgOnly.json -p <(pyhf patchset extract Rpc2L0b_patchset.json --name "spec_Rpc2L0b_signal376822_1900_800")

jsonpatch Rpc2L0b_BkgOnly.json <(pyhf patchset extract Rpc2L0b_patchset.json --name "spec_Rpc2L0b_signal376822_1900_800") | pyhf cls

pyhf cls Rpc2L0b_spec_Rpc2L0b_signal376822_1900_800.json
```