# JSON Likelihoods for ATLAS SUSY displaced vertex and displaced muon search (SUSY-2018-33)

The JSON likelihoods are serialized for each signal region: [SRMU](SRMU), [SRMET](SRMET). This is done by providing a background-only workspace containing the signal channels for each region at `[region]_bkgonly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `[region]_patchset.json`.

Each [jsonpatch](http://jsonpatch.com/) file follows the format `StopRHadron_[m]_[tau]` where `m` is the mass of the stop R-hadron, and `tau` is the lifetime in picoseconds.

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:
```
jq '.patches[].metadata.name' SRMET_patchset.json
```
shown here for SRMET only.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch SRMET_bkgonly.json <(pyhf patchset extract SRMET_patchset.json --name "StopRHadron_1000_10") > SRMET_StopRHadron_1000_10.json
```
here shown as an example for a signal model `StopRHadron_1000_10`.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls SRMET_bkgonly.json -p <(pyhf patchset extract SRMET_patchset.json --name "StopRHadron_1000_10") 

jsonpatch SRMET_bkgonly.json <(pyhf patchset extract SRMET_patchset.json --name "StopRHadron_1000_10") | pyhf cls

pyhf cls SRMET_StopRHadron_1000_10.json
```
