# JSON Likelihoods for ATLAS SUSY inclusive 0L 2-6 jets analysis (SUSY-2018-22)

The JSON likelihoods are serialized for each signal region: 
Multi-bin regions: 
MB-C, MB-SSd, MB-GGd
Single-bin BDT regions: 
BDT-GGd1,BDT-GGd2,BDT-GGd3,BDT-GGd4,BDT-GGo1,BDT-GGo2,BDT-GGo3,BDT-GGo4,
Single-bin discovery regions:
SR2j-1600, SR2j-2200, SR2j-2800, SR4j-1000, SR4j-2200, SR4j-3400, SR5j-1600, SR6j-1000, SR6j-2200, SR6j-3400

This is done by providing a background-only workspace containing the signal channels for
each region at `[region]_bkgonly.json`.

For the multi-bin regions also patch files for each mass point on the signal phase-space explored in the analysis are provided, at `[region]_patchset.json`.

Each [jsonpatch](http://jsonpatch.com/) file follows the format `Spec_Fit_[signal]_[m0]_[m1].json` where `m0` is the mass of the gluino (for MB-GGd), the squark (for MB-SSd and MB-C) respectively, and `m1` is the mass of the lightest supersymmetric particle (LSP).

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:
```
jq '.patches[].metadata.name' MB-GGd_patchset.json
```
shown here for MB-GGd only.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch MB-GGd_bkgonly.json <(pyhf patchset extract MB-GGd_patchset.json --name "Spec_Fit_GG_direct_2400_1100") > MB-GGd_Spec_Fit_GG_direct_2400_1100.json
```
here shown as an example for a signal model `Spec_Fit_GG_direct_2400_1100`.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls MB-GGd_bkgonly.json -p <(pyhf patchset extract MB-GGd_patchset.json --name "Spec_Fit_GG_direct_2400_1100")

jsonpatch MB-GGd_bkgonly.json <(pyhf patchset extract MB-GGd_patchset.json --name "Spec_Fit_GG_direct_2400_1100") | pyhf cls

pyhf cls MB-GGd_Spec_Fit_GG_direct_2400_1100.json
```
