# HistFactory Likelihoods for the ATLAS SUSY Electroweak/RPV 4L search
The HistFactory likelihoods of the four-lepton search is serialised in JSON.
The likelihoods can be provided as input or manipulated with [pyhf](https://iris-hep.org/projects/pyhf.html).

A background-only workspace is provided  bgOnly_likelihood.json
Information relative to the signal models is contained in files called 'patchsets'.
Patchsets are provided for all signal regions -- but please be careful, as some overlap with one another and cannot be combined. Careful pruning is needed to avoid these overlaps.
- SR0ZZloose, SR0ZZtight, SR0ZZbvetoloose, SR0ZZbvetotight all overlap with one another
- SR0bvetoloose, SR0bvetotight overlap with one another
- SR1bvetoloose, SR1bvetotight overlap with one another
- SR2bvetoloose, SR2bvetotight overlap with one another
- SR5L overlaps with all SR0* SRs
The following signal models are provided
   GGM Higgsino: GGM_unblinded_patchset.json
   Wino NLSP with LLE12k!=0: Wino12k_unblinded_patchset.json
   Wino NLSP with LLEi33!=0: Winoi33_unblinded_patchset.json
   Slep/Snu NLSP with LLE12k!=0: LV12k_unblinded_patchset.json
   Slep/Snu NLSP with LLEi33!=0: LVi33_unblinded_patchset.json
   Gluino NLSP with LLE12k!=0: GG12k_unblinded_patchset.json
   Gluino NLSP with LLEi33!=0: GGi33_unblinded_patchset.json

Generally, the best SRs to use for the
- RPV models is the combination of SR0bvetotight,SR0breq,SR1bvetotight,SR1breq,SR2bvetotight,SR2breq. All others should be pruned.
- GGM models is the best expected CLs of SR0ZZloose or SR0ZZtight or SR0ZZbvetoloose or SR0ZZbvetotight. All SRs but the one being tested should be pruned.

### Performing a fit

In order to perform a fit, a background workspace has to be applied a patch.
For example, if the desired signal point is defined by m(Wino) = 1500 GeV and m(LSP) = 800 GeV, the likelihood including the three tight bveto regions and the breq regions and the breq regions (pruning all others) is built with:
```
pyhf patchset apply --name Wino_1800_900_LLE12k bgOnly_likelihood.json Wino12k_unblinded_patchset.json --output-file Wino12k_1800_900_from_patch.json
pyhf prune Wino12k_1800_900_from_patch.json --output-file Wino12k_1800_900_pruned.json -c SR5L_cuts -c SR0ZZloose_cuts -c SR0ZZtight_cuts -c SR0ZZbvetoloose_cuts -c SR0ZZbvetotight_cuts -c SR0bvetoloose_cuts -c SR1bvetoloose_cuts -c SR2bvetoloose_cuts
```
Note that all SRs except the 6 we wish to combine are pruned away. For a GGM scenario, run one of the four possible SRs at a time, pruning all others.

The string following the --name option is the patch name. 
All RPV signal names in the patches follow this pattern:
```
{NLSP type}_{NLSP mass}_{LSP mass}_{LLE coupling}
```
While all the GGM signal names follow this pattern:
```
GGM{Higgsino mass}_{BR(N1 to Z)}
```

The exclusion fit can be run with:
```
pyhf cls Wino12k_1800_900_pruned.json
```

### Additional Notes

`pyhf` v0.6.2+ is recommended to use these patchsets. See [scikit-hep/pyhf#1488](https://github.com/scikit-hep/pyhf/pull/1488) for more details.
