# HistFactory Likelihoods for ATLAS SUSY Electroweak soft leptons search (SUSY-2018-16)

The HistFactory likelihoods are serialized in JSON for the different searches performed (`{region}`): `EWKinos`, `Sleptons`, `Selectrons`, `Smuons`. This is done by providing a background-only workspace containing the signal channels for each region at `{region}_bkgonly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `{region}_patchset.json`.

## EWKinos

For the electroweak-ino searches involving C1, N2, N1; there are three model interpretations split by `kind`:

- `Higgsino`: signal models with `mu < M1, M2`, a Higgsino-like lightest supersymmetric particle (LSP), with C1 as the NLSP
- `WinoBino_noWeight`: signal models with `mu > M1, M2`, a bino-like LSP and a wino-like NLSP, with `sign(m(N1))==sign(m(N2))`, with N2 as the NLSP
- `WinoBino_MllWeight`: same as `WinoBino_noWeight` but with the dilepton mass (`Mll`) distribution reweighted to match the `Higgsino`, to model WinoBino scenarios with `sign(m(N1))==-1*sign(m(N2))`

Each [jsonpatch](http://jsonpatch.com/) follows the format `MGPy8EG_A14N23LO_{kind}_{mN2}_{mN1}_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun` where `kind` is one of the above, `mN2` is the mass of the N2, and `mN1` is the mass of the LSP; masses in units of GeV.

## Sleptons

There are three different direct slepton searches to consider:

- `Sleptons`: degenerate light-flavour sleptons, `m(smuon) == m(selectron)`
- `Selectrons`: only selectrons with dedicated electron channels and systematics, `m(smuon) >>> m(selectron)`
- `Smuons`: only smuons with dedicated muon channels and systematics, `m(smuon) <<< m(selectron)`

The left-handed (LH) and right-handed (RH) components of the charged, light-flavour Standard Model (SM) leptons each have their own superpartners denoted by `slep_L` and `slep_R` respectively. For each of the direct slepton searches, there are three model interpretations split by `chirality`:

- `degenerate`: signal models with `m(slep_L) == m(slep_R)`
- `RH`: signal models with `m(slep_L) >>> m(slep_R)`, considering only sleptons partnered with the RH SM leptons
- `LH`: signal models with `m(slep_R) >>> m(slep_L)`, considering only sleptons partnered with the LH SM leptons

Each [jsonpatch](http://jsonpatch.com/) follows the format:

- `Sleptons`: `MGPy8EG_A14N23LO_SlepSlep_direct_{chirality}_{mL}_{mN1}_2L2MET75_excl_AllSys_HghMETLowMET_V2_sepNF_prun`
- `Selectrons`: `MGPy8EG_A14N23LO_SlepSlep_direct_{chirality}_{mL}_{mN1}_2L2MET75_excl_AllSys_HghMETLowMET_V2ee_sepNF_prun`
- `Smuons`: `MGPy8EG_A14N23LO_SlepSlep_direct_{chirality}_{mL}_{mN1}_2L2MET75_excl_AllSys_HghMETLowMET_V2mm_sepNF_prun`

where `chirality` is one of the above, `mL` is the mass of the slepton (NLSP), and `mN1` is the mass of the LSP; masses in units of GeV. Note that each of the flavour differences has a minor subtlety in the name where Selectrons and Smuons have `V2ee` and `V2mm` respectively.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch EWKinos_bkgonly.json <(pyhf patchset extract EWKinos_patchset.json \
                                  --name "MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun") \
                               > MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun.json
```

or

```
pyhf patchset apply EWKinos_bkgonly.json EWKinos_patchset.json \
                    --name "MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun" \
                    --output-file "MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun.json"
```

here shown as an example for a Higgsino model `MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun` with `dM(N2,N1)` of 15 GeV.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf patchset inspect EWKinos_patchset.json

pyhf cls EWKinos_bkgonly.json -p <(pyhf patchset extract EWKinos_patchset.json --name "MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun")

jsonpatch EWKinos_bkgonly.json <(pyhf patchset extract EWKinos_patchset.json --name "MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun") | pyhf cls

pyhf cls MGPy8EG_A14N23LO_WinoBino_MllWeight_175p0_160p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun.json
```

### Programmatically Accessing Patches

One could use the nice bookkeeping provided by `pyhf.PatchSet` to extract out patches across interpretations. For example, if we look at the `EWKinos_patchset.json` file:

```python
>>> import pyhf, json
>>> ps = pyhf.PatchSet(json.load(open('EWKinos_patchset.json')))
>>> ps.labels
['kind', 'mN2', 'mN1']
>>> ps[('Higgsino', 100.0, 60.0)]
<pyhf.patchset.Patch object 'MGPy8EG_A14N23LO_Higgsino_100_60_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun('Higgsino', 100.0, 60.0)' at 0x13cdc3d00>
>>> ps[('WinoBino_noWeight', 100.0, 60.0)]
<pyhf.patchset.Patch object 'MGPy8EG_A14N23LO_WinoBino_noWeight_100p0_60p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun('WinoBino_noWeight', 100.0, 60.0)' at 0x13cdbebe0>
>>> ps[('WinoBino_MllWeight', 100.0, 60.0)]
<pyhf.patchset.Patch object 'MGPy8EG_A14N23LO_WinoBino_MllWeight_100p0_60p0_2L2MET75_MadSpin_excl_AllSys_HghMETLowMETIsoTrk_sepNF_prun('WinoBino_MllWeight', 100.0, 60.0)' at 0x13cdbe100>
```

The patches could be extracted using a tuple of values associated with the labels in the patchset, rather than just accessing the patch by the full name.

## Additional Notes

`pyhf` v0.6.2+ is required to use these patchsets. See [scikit-hep/pyhf#1488](https://github.com/scikit-hep/pyhf/pull/1488) for more details.
