# HistFactory JSON workspaces for ATLAS SUSY strong multi-b-jet analysis (SUSY-2018-30)

The workspaces are serialized for both the cut-and-count (`CC`) and multi-binned (`NN`) approaches, for each signal category (`Gtt_X_Y`, `Gtt_0L`, `Gtt_1L`, `Gbb`, `Gbb_X_Y`), for each region: boosted (`B`), moderate (`M`, `M1`, `M2`), and compressed (`C`). This is done by providing a background-only workspace for each region at `{approach}_{signal}_{region}_bkgonly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `{approach}_{signal}_{region}_bkgonly.json`.

In particular, the multi-binned approach uses a neural network trained with different signal categories parametrized by the masses of the gluino and neutralino in GeV. The following `{approach}_{signal}_{region}` combinations are provided:

* `CC_Gbb_{B,M,C}`
* `CC_Gtt_{0L,1L}_{B,M1,M2,C}`
* `NN_Gbb_2000_1800`
* `NN_Gbb_2100_1600`
* `NN_Gbb_2300_1000`
* `NN_Gbb_2800_1400`
* `NN_Gtt_1800_1`
* `NN_Gtt_1900_1400`
* `NN_Gtt_2100_1`
* `NN_Gtt_2300_1200`

Note that due to zero signal efficiency, the following signal patches are dropped from the `CC_Gbb_C` patchset (gluino, stop, neutralino):

* (1300, 5000, 1280)
* (1800, 5000, 1780)
* (1500, 5000, 1480)
* (1100, 5000, 1080)

One can list all the patches available in a patchset.json file using for example [jq](https://stedolan.github.io/jq/), like:

```
jq '.patches[].metadata.name' CC_Gbb_B_patchset.json
```

or using [pyhf](https://scikit-hep.org/pyhf/):

```
pyhf patchset inspect patchsets/CC_Gbb_B_patchset.json
```

Each [jsonpatch](http://jsonpatch.com/) follows the format `{approach}_{signal}_{region}_excl_{signalType}_{mGluino}_{mStop}_{mLSP}` where `signalType` is the type of signal used (`Gtt` or `Gbb`), `mGluino` is the mass of the gluino, `mStop` is the (off-shell) mass of the stop squark, and `mLSP` is the mass of the lightest supersymmetric particle (LSP), typically neutralino. All masses are in units of GeV.

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch CC_Gbb_B_bkgonly.json <(pyhf patchset extract CC_Gbb_B_patchset.json --name "CC_Gbb_B_excl_Gbb_1100_5000_1") > CC_Gbb_B_excl_Gbb_1100_5000_1.json
```
here shown as an example for a signal model `CC_Gbb_B_excl_Gbb_1100_5000_1`.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf cls CC_Gbb_B_bkgonly.json -p <(pyhf patchset extract CC_Gbb_B_patchset.json --name "CC_Gbb_B_excl_Gbb_1100_5000_1")

jsonpatch CC_Gbb_B_bkgonly.json <(pyhf patchset extract CC_Gbb_B_patchset.json --name "CC_Gbb_B_excl_Gbb_1100_5000_1") | pyhf cls

pyhf cls CC_Gbb_B_excl_Gbb_1100_5000_1.json
```
