# JSON Likelihoods for ATLAS HDBS mono-H(tautau) searches (HDBS-2018-50)

The JSON likelihoods are serialized for three combinations of signal region and signal grid: [LowmASR+mA vs ma signal grid](regionA/), [HighmASR+ mA vs ma signal grid](regionB/), [LowmASR+mA vs tanBeta signal grid](regionC/). This is done by providing a background-only workspace containing the signal channels for each region at `BkgOnly.json` as well as patch files for each mass point on the signal phase-space explored in the analysis. 
 
Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like this:

jsonpatch regionA/BkgOnly.json regionA/patch_sig_pyhf_low_tb1_sp035_mA400_ma200.json | jq > sig_pyhf_low_tb1_sp035_mA400_ma200.json.json

Then, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the standard pyhf things, e.g.:

pyhf cls sig_pyhf_low_tb1_sp035_mA400_ma200.json.json 
