# HistFactory Likelihoods for ATLAS SUSY Electroweak fully-hadronic search (SUSY-2018-41)

The HistFactory likelihoods are serialized in JSON. 
For the hypothetic tests calculating the exclusion, a background-only fit likelihood workspace `BGOnly_{grid}.json` is provided for each signal grid, specified by the label {grid}.
The patch is defined for each mass point of the grid in the patchset file (`patchset_{grid}.json`) that can be applied to generate the signal workspace for a given mass point of the grid.
The signal workspace can be then used to calculate the CLs value using `pyhf`.

# Supported signals grids
- `SM_C1C1_WW`: (W~,B~) simplified model C1C1->WW+N1N1. mHeavy=mC1=mN2, mLight=mN1.
- `SM_C1N2_WZ` (W~,B~) simplified model C1N2->WZ+N1N1. mHeavy=mC1=mN2, mLight=mN1.
- `SM_C1N2_Wh` (W~,B~) simplified model C1N2->Wh+N1N1. mHeavy=mC1=mN2, mLight=mN1.
- `SM_C1N2N1_GGMHino`: (H~,G~) model with variable B(N1->h+G~).  mHeavy=mC1=mN2=mN1. B(N1->Z+G~)=1-B(N1->h+G~).
- `winoBino_brN2H50`: (W~,B~) model with B(N2->hN1)=(0,25,50,75,100)%. mHeavy=mC1=mN2, mLight=mN1.
- `hinoBino_brN2H50`: (H~,B~) model with B(N2->hN1)=B(N3->ZN1)=(0,25,50)%. mHeavy=mC1=mN2=mN3, mLight=mN1. 
- `hinoWino_tanb10_posMu`: (H~,W~) model with tan(beta)=10 and mu>0. mHeavy=mC2=mN2=mN3, mLight=mC1=mN1.
- `winoHino_tanb10_posMu`: (W~,H~) model with tan(beta)=10 and mu>0. mHeavy=mC2=mN3, mLight=mC1=mN2=mN1.
- `hinoAxino_brN2H{X}`: (H~,a~) model with B(N1->h+a~)=X% (0,25,50,75,100).  mHeavy=mC1=mN2=mN1, mLight=mAxino.
(A,B) in the grid names represent the (heavy,light) EWKino states (See more in the Section 2 of the [paper](https://atlas.web.cern.ch/Atlas/GROUPS/PHYSICS/PAPERS/SUSY-2018-41/)).

Each background-only fit workspace contains different SRs as described in the Table 1 of the [paper](https://atlas.web.cern.ch/Atlas/GROUPS/PHYSICS/PAPERS/SUSY-2018-41/).
When testing the exclusion of your custom signals, pick up a proper background-only fit workspace depending on the what SRs you want to use.
For the most general case, it is adviced to use  `BGOnly_hinoWino_tanb10_posMu.json` or `BGOnly_winoHino_tanb10_posMu.json` since they use the most incluvie combination of the SRs.

# Notes
- The `hinoWino` and `winoHino` patchsets for the other (tan(beta), sign(mu)) combinations are not provided since the variation is found to make minor difference in the exclusion.
- All the [jsonpatches](http://jsonpatch.com/) except for `SM_C1N2N1_GGMHino` follow the format of: `Sig_sig_{grid}_{mHeavy}_{mLight}` where `grid` is one of the above, `mHeavy` and `mLight` are the physical masses of heavy and light EWKino respectively (the effect of mixing is ignored due to the regime with a large mass spliting (`mHeavy-mLight>400GeV`) assumed in the analysis.
- For the `SM_C1N2N1_GGMHino` the patch has the format of: `Sig_sig_SM_C1N2N1_GGMHino_{mHeavy}_brH{BRH}` where `BRH` is the branching ratio of the lightest higgsino (`N1`) into `h+G~` in %.


# How to execute?

## Producing signal workspaces

Signal workspaces can be produced using [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/) like:

```
jsonpatch BGOnly_SM_C1N2_WZ.json <(pyhf patchset extract patchset_SM_C1N2_WZ.json \
                                  --name "Sig_sig_SM_C1N2_WZ_900_0") \
                               > Sig_sig_SM_C1N2_WZ_900_0.json
```

or

```
pyhf patchset apply BGOnly_SM_C1N2_WZ.json patchset_SM_C1N2_WZ.json \
                    --name "Sig_sig_SM_C1N2_WZ_900_0" \
                    --output-file "Sig_sig_SM_C1N2_WZ_900_0.json"
```

here shown as an example for a Wino-NLSP/Bino-LSP simplified model `SM_C1N2_WZ` with (mHeavy,mLight)=(900,0)GeV.

## Computing signal workspaces

For example, with [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:

```
pyhf patchset inspect patchset_SM_C1N2_WZ.json

pyhf cls BGOnly_SM_C1N2_WZ.json -p <(pyhf patchset extract patchset_SM_C1N2_WZ.json --name "Sig_sig_SM_C1N2_WZ_900_0")

jsonpatch BGOnly_SM_C1N2_WZ.json <(pyhf patchset extract patchset_SM_C1N2_WZ.json --name "Sig_sig_SM_C1N2_WZ_900_0") | pyhf cls

pyhf cls Sig_sig_SM_C1N2_WZ_900_0.json
```

### Programmatically Accessing Patches

One could use the nice bookkeeping provided by `pyhf.PatchSet` to extract out patches across interpretations. For example, if we look at the `patchset_SM_C1N2_WZ.json` file:

```python
>>> import pyhf, json
>>> ps = pyhf.PatchSet(json.load(open('patchset_SM_C1N2_WZ.json')))
>>> ps.labels
['mHeavy', 'mLight']
>>> ps[(900, 0)]
<pyhf.patchset.Patch object 'Sig_sig_SM_C1N2_WZ_900_0(900.0, 0.0)' at 0x131b36100>
```

The patches could be extracted using a tuple of values associated with the labels in the patchset, rather than just accessing the patch by the full name.

## Additional Notes

`pyhf` v0.6.2+ is required to use these patchsets. See [scikit-hep/pyhf#1488](https://github.com/scikit-hep/pyhf/pull/1488) for more details.
