# HistFactory Likelihoods for ATLAS SUSY Electroweak Compressed Displaced Track search (SUSY-2020-04)

The HistFactory likelihoods are serialized in JSON format. This is done by providing a background-only workspace containing the signal channels at `bkg_only.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `patchset.json`.

Signal patches in the patchset.json file follow the `MGPy8EG_A14N23LO_HH_[dM]_[mH]` naming convention, where the `dM` is the mass splitting between the lightest chargino and the lightest neutralino, and `mH` is the mass of the lightest neutralino considered to be the LSP. 

One can list all the patches available in the patchset.json file using for example [pyhf](https://scikit-hep.org/pyhf/), like:
```
pyhf patchset inspect patchset.json
```

## Producing signal workspaces

Signal workspaces can be produced using python [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and pyhf like:
```
jsonpatch  bkg_only.json <(pyhf patchset extract patchset.json --name MGPy8EG_A14N23LO_HH_dM0p5_150p0)> MGPy8EG_A14N23LO_HH_dM0p5_150p0.json
```
here shown as an example for the MGPy8EG_A14N23LO_HH_dM0p5_150p0 signal model with (dM, mH) = (0.5, 150) GeV.

## Computing signal workspaces

For example, with [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:
```
pyhf cls bkg_only.json -p <(pyhf patchset extract patchset.json --name "MGPy8EG_A14N23LO_HH_dM0p5_150p0")

jsonpatch bkg_only.json <(pyhf patchset extract patchset.json --name "MGPy8EG_A14N23LO_HH_dM0p5_150p0") | pyhf cls

pyhf cls MGPy8EG_A14N23LO_HH_dM0p5_150p0.json
```
again shown as an example for the MGPy8EG_A14N23LO_HH_dM0p5_150p0 signal model with (dM, mH) = (0.5, 150) GeV.

## Additional Notes

JSON workspaces have been produced and validated **only** using `numpy` and `scipy` respectively as backend and optimizer for pyhf. 
