# HistFactory Likelihoods for the ATLAS SUSY Electroweak search with tau-leptons
The HistFactory likelihoods of the search is serialised in JSON.
The likelihoods can be provided as input or manipulated with [pyhf](https://iris-hep.org/projects/pyhf.html).


A background-only workspace is provided for each set of signal regions *_backgroundOnly.json
StauStau_* contains the information for SR-BDT1, SR-BDT2, SR-BDT3 and SR-BDT4
SR_C1C1_* contains the information for SR-C1C1-LM and SR-C1C1-HM
SR_C1N2OS_* contains the information for SR-C1N2OS-LM and SR-C1N2OS-HM
SR_Wh_LM_* contains the information for SR-Wh-LM
SR_Wh_LM_* contains the information for SR-Wh-HM
Information relative to the signal models is contained in files called 'patchsets'.
Patchsets are provided for models relevant for all signal regions -- but please be careful, as some overlap with one another and cannot be combined. 
- SR-BDT1, SR-BDT2, SR-BDT3, and SR-BDT4 overlap with one another
- SR-C1C1-LM and SR-C1N2OS-LM overlap with one another
- SR-C1C1-HM and SR-C1N2OS-HM overlap with one another
- SR-Wh-LM and SR-Wh-HM overlap with one another

The following signal models are provided
   Direct stau production (left and right-handed): StauStauLR_*_patchset.json
   Direct stau production (left-handed only): StauStauL_*_patchset.json
   Direct stau production (right-handed only): StauStauR_*_patchset.json
   Chargino production with intermediate stau: C1C1_* patchset.json
   Chargino-neutralino production with intermediate stau: C1N2_*_patchset.json
   Chargino-neutralino production with intermediate Wh: Wh_*_patchset.json

Generally, the best SRs to use for the
- Direct stau production is the SR with the best expected CLs of SR-BDT1, SR-BDT2, SR-BDT3, SR-BDT4
- Chargino production with intermediate stau is the combination of SR-C1C1-LM and SR-C1C1-HM
- Chargino-neutralino production with intermediate stau is the combination of SR-C1N2OS-LM,SR-C1N2OS-HM,SR-C1N2SS-LM,SR-C1N2SS-HM
- Chargino-neutralino production with intermediate Wh is the SR with the best expected CLs of SR-Wh-LM and SR-Wh-HM

### Performing a fit

In order to perform a fit, a background workspace has to be applied a patch.
For example, if the desired signal point is defined by m(stau) = 400 GeV and m(LSP) = 200 GeV, the likelihood including the SR-BDT1 region (ignoring the other overlapping SRs) is built with:
```
cd Likelihoods_StauStau
pyhf patchset apply --name StauStauLR_400_200_BDT1 StauStau_backgroundOnly.json StauStauLR_BDT1_patchset.json  --output-file StauStauLR_400_200_BDT1_from_patch.json

The exclusion fit can be run with:
```
pyhf cls StauStauLR_400_200_BDT1_from_patch.json
```

The string following the --name option is the patch name. 
All signal names in the patches follow this pattern:
```
{NLSP type and decaymode}_{NLSP mass}_{LSP mass}_{SignalRegion}
```


### Additional Notes

`pyhf` v0.6.2+ is recommended to use these patchsets. See [scikit-hep/pyhf#1488](https://github.com/scikit-hep/pyhf/pull/1488) for more details.
