# HistFactory Likelihoods for ATLAS HMBS Electroweak Slepton-Binp-Higgsino search (HMBS-2024-11)

The HistFactory likelihoods are serialized in JSON format. This is done by providing a background-only workspace containing the signal channels at `bkg_only.json` as well as patch files for each mass point on the signal phase-space explored in the analysis, at `patchset.json`.

Signal patches in the patchset.json file follow the `Sig_SBH_[mSlep]_[mBino]_[mLSP]` naming convention, where the `mSlep` is the slepton mass, the `mBino` is the chi^0_3 mass, and the `mLSP` is the LSP mass.

One can list all the patches available in the patchset.json file using for example [pyhf](https://scikit-hep.org/pyhf/), like:
```
pyhf patchset inspect patchset.json
```

## Producing signal workspaces

Signal workspaces can be produced using python [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and pyhf like:
```
jsonpatch  bkg_only.json <(pyhf patchset extract patchset.json --name Sig_SBH_300_200_100)> Sig_SBH_300_200_100.json
```
here shown as an example for the Sig_SBH_300_200_100 signal model with (mSlep, mBino, mLSP) = (300, 200, 100) GeV.

## Computing signal workspaces

For example, with [python jsonpatch](https://python-json-patch.readthedocs.io/en/latest/) and [pyhf](https://scikit-hep.org/pyhf/), one can do any of the following:
```
jsonpatch bkg_only.json <(pyhf patchset extract patchset.json --name "Sig_SBH_300_200_100") | pyhf cls

pyhf cls Sig_SBH_300_200_100.json
```
again shown as an example for the Sig_SBH_300_200_100 signal model with (mSlep, mBino, mLSP) = (300, 200, 100) GeV.

## Additional Notes

JSON workspaces have been produced and validated **only** using `numpy` and `scipy` respectively as backend and optimizer for pyhf. 
